#ifndef LINT
static char *rcsid="$Id: clamav.c 436 2006-12-17 11:06:26Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#include <zmscanner.h>
#include <clamav.h>

#ifdef HAVE_FILETYPES_H
# include <filetypes.h>
#endif

#include "clamav_config.h"
#include "report.h"

int clamav_refreshdb(clamav_cfg_t *);
void pre_scan(void);
void post_scan(void);

#define CONFFILE "clamav.conf"

#define min(x,y) ((x<y)?x:y)

static int
need_filescan(char *buf, size_t buflen)
{
	int rc=1;
#ifdef HAVE_FILETYPES_H
	cli_file_t filetype;

	filetype=cli_filetype(buf,buflen);
	switch (filetype) {
	case CL_TYPE_UNKNOWN_TEXT:
	case CL_TYPE_UNKNOWN_DATA:
	/* case CL_TYPE_MSEXE: not all exe's need filescan but how to tell?? */
	case CL_TYPE_DATA:
	case CL_TYPE_GRAPHICS:
	case CL_TYPE_RIFF:
	case CL_TYPE_HTML:
		rc=0;
		break;
	default:
		rc=1;
		break;
	}
	DPRINT(("need_filescan filetype=%d, rc=%d\n",(int)filetype,rc));
#else /* HAVE_FILETYPES_H */
	DPRINT(("need_filescan always true\n"));
#endif /* HAVE_FILETYPES_H */
	return rc;
}

static int
clamav_setup(void **priv)
{
	clamav_cfg_t *cfg;
	int rc;
	char fbuf[128];

	DPRINT(("clamav_setup starting\n"));

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),CONFFILE);
	cfg=clamav_config(fbuf);
	cfg->finaldbdir=cfg->dbdir?cfg->dbdir:cl_retdbdir();
	(*priv)=(void *)cfg;
	rc=clamav_refreshdb(cfg);
	if (rc) return rc;
	ERRLOG((LOG_INFO,"clamav: use %s scanning",
					cfg->filescan?"file":"memory"));
	ERRLOG((LOG_INFO,"clamav: %s (%s); libclamav level %d version %s OK",
		VERSION,rcsid,cl_retflevel(),cl_retver()));

	return 0;
}

static void
clamav_term(void **priv)
{
	clamav_cfg_t *cfg=*((clamav_cfg_t **)priv);

	if (cfg) {
		cl_free(cfg->root);
		free(cfg);
	}
	*priv=NULL;
}

static int
clamav_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	clamav_cfg_t *cfg=(clamav_cfg_t *)priv;
	int rc=-1;
	const char *virname;
	mattr_t *atr=data.atr;
	char ans[128];

	DPRINT(("clamav_scan enter\n"));

	if (!cfg->scantext &&
	    !((atr) && (slab_size(atr->content_type)) &&
	      (strncasecmp(atr->content_type.beg,"text",
				min(4,slab_size(atr->content_type))) != 0))) {
		DPRINT(("not scanning text type\n"));
		return ZMSCAN_CONTINUE;
	}

#ifdef HAVE_CL_SCANBUFF
	if (cfg->filescan && need_filescan(data.beg,slab_size(data))) {
#else
	if (1) {
#endif
		FILE *tmpf=tmpfile();
		size_t rest=slab_size(data);
		char *p=data.beg;
		struct stat st;

		DPRINT(("clamav file scan, options=0x%04x\n",cfg->clamopts));
		if (tmpf == NULL) {
			ERRLOG((LOG_ERR,"clamav_scan: open tmp file: %m"));
			goto bailout;
		}
		while (rest) {
			size_t wrote=fwrite(p,1,rest,tmpf);
			rest-=wrote;
			if (ferror(tmpf)) {
				ERRLOG((LOG_ERR,"clamav_scan: fwrite tmp: %m"));
				goto bailout;
			}
		}
		if (fflush(tmpf)) {
			ERRLOG((LOG_ERR,"clamav_scan: fflush tmp file: %m"));
			goto bailout;
		}
		if (fstat(fileno(tmpf),&st)) {
			ERRLOG((LOG_ERR,"clamav_scan: stat tmp file: %m"));
			goto bailout;
		} else {
			DPRINT(("clamav file scan, size=%ld\n",
						(long)st.st_size));
		}
		pre_scan();
		rc=cl_scandesc(fileno(tmpf),&virname,NULL,cfg->root,
			&cfg->limits,cfg->clamopts);
		post_scan();
		DPRINT(("clamav file scan result=%d (%s)\n",
				rc,rc?virname:"-"));
		bailout:
		if (tmpf) fclose(tmpf);
	} else {
		pre_scan();
		rc=cl_scanbuff(data.beg,slab_size(data),&virname,cfg->root);
		post_scan();
	}
	switch (rc) {
	case CL_CLEAN:
		DPRINT(("clamav scan result clean\n"));
		return ZMSCAN_CONTINUE;
	case CL_VIRUS:
		ERRLOG((LOG_INFO,"clamav: blocked %s",virname));
		snprintf(ans,sizeof(ans),
			"-1 550 5.7.0 Found virus %s in the message",virname);
		vp_set_str(vp,VP_ANSWER_STR,ans);
		return ZMSCAN_STOP;
	default:
		ERRLOG((LOG_ERR,"clamav_scan scan result %s (%d)",
				cl_strerror(rc),rc));
		return ZMSCAN_CONTINUE;
	}
}

ZMS_MODULE("content","clamav",clamav_setup,clamav_term,clamav_scan);

