#ifndef LINT
static char *rcsid="$Id";
#endif
                                                                                
/*
	$Log: clamav_config.c,v $
	Revision 1.1  2004/12/14 00:25:34  crosser
	make configuration: options, limits etc.
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif

#include <clamav.h>
#include "clamav_config.h"
#include "zmscanner.h"
#include "report.h"

#ifndef offsetof
# define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

static struct _opts {
	char *verb;
	int flag;
} opts[] = {
	{"archive",		CL_SCAN_ARCHIVE},
	{"blockbroken",		CL_SCAN_BLOCKBROKEN},
	{"blockencrypted",	CL_SCAN_BLOCKENCRYPTED},
	{"blockmax",		CL_SCAN_BLOCKMAX},
#ifdef CL_SCAN_DISABLERAR
	{"disablerar",		CL_SCAN_DISABLERAR},
#endif /* CL_SCAN_DISABLERAR */
	{"html",		CL_SCAN_HTML},
	{"ole2",		CL_SCAN_OLE2},
	{"pe",			CL_SCAN_PE},
#ifdef CL_SCAN_ALGO
	{"algo",		CL_SCAN_ALGO},
#endif /* CL_SCAN_ALGO */
#ifdef CL_SCAN_MAILURL
	{"mailurl",		CL_SCAN_MAILURL},
#endif /* CL_SCAN_MAILURL */
#ifdef CL_SCAN_NOPHISHING
	{"nophishing",		CL_SCAN_NOPHISHING},
#endif /* CL_SCAN_NOPHISHING */
#ifdef CL_PHISH_NO_DOMAINLIST
	{"nodomainlist",	CL_PHISH_NO_DOMAINLIST},
#endif /* CL_PHISH_NO_DOMAINLIST */
	{NULL,			0}
};

unsigned int
verb_options(char *data,char *fn,int count)
{
	unsigned int options=0;
	char *p,*q;
	int up;
	int i;

	DPRINT(("parsing options \"%s\"\n",data));
	options=CL_SCAN_STDOPT & ~CL_SCAN_MAIL;
	for (p=data;*p;) {
		for (q=p;(*q != '\0') && (*q != ' ') && (*q != ',');q++) ;
		if (*q != '\0') *q++='\0';
		while (*q && (*q == ' ')) q++;
		DPRINT(("option \"%s\"\n",p));
		if (*p == '+') { up=1; p++; }
		else if (*p == '-') { up=0; p++; }
		else { up=1; }
		for (i=0;opts[i].verb;i++) {
			if (strcasecmp(p,opts[i].verb) == 0) break;
		}
		if (opts[i].verb) {
			if (up) options |= opts[i].flag;
			else options &= ~opts[i].flag;
		} else {
			ERRLOG((LOG_ERR,"%s(%d): unknown option %s",
								fn,count,p));
		}
		p=q;
	}
	return options;
}

static struct _verbs {
	char *verb;
	enum {badverb,boolean,integer,string,options} vtype;
	size_t where;
} verbs[] = {
	{"dbdir",	string,	offsetof(clamav_cfg_t,dbdir)},
	{"scantext",	boolean,offsetof(clamav_cfg_t,scantext)},
	{"filescan",	boolean,offsetof(clamav_cfg_t,filescan)},
	{"options",	options,offsetof(clamav_cfg_t,clamopts)},
	{"maxfiles",	integer,offsetof(clamav_cfg_t,limits.maxfiles)},
	{"maxfilesize",	integer,offsetof(clamav_cfg_t,limits.maxfilesize)},
	{"maxreclevel",	integer,offsetof(clamav_cfg_t,limits.maxreclevel)},
	{"maxratio",	integer,offsetof(clamav_cfg_t,limits.maxratio)},
	{NULL,		badverb,0}
};

clamav_cfg_t *
clamav_config(char *fn)
{
	clamav_cfg_t *cfg;
	FILE *fp;
	char buf[256];
	char fbuf[128];
	int count=0;
	int options_set=0;

	cfg=(clamav_cfg_t *)malloc(sizeof(clamav_cfg_t));
	memset(cfg,0,sizeof(clamav_cfg_t));
	cfg->clamopts=CL_SCAN_STDOPT & ~CL_SCAN_MAIL;

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),fn);

	DPRINT(("clamav_config fn=%s\n",fn));

	if ((fp=fopen(fn,"r")) == NULL) {
		perror(fn);
		return cfg;
	}
	while (fgets(buf,sizeof(buf)-1,fp)) {
		char *p,*q;
		int i,factor;
		int options_set=0;

		count++;
#if 0
		DPRINT(("clamav_config line %d: \"%s\"\n",count,buf));
#endif
		if (buf[0] == '#') continue;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		while ((p >= buf) && ((*p == '\r') || (*p == '\n') ||
				     (*p == ' ') || (*p == '\t'))) *p--='\0';
		if (buf[0] == '\0') continue;
		for (p=buf;(*p != ' ') && (*p != '\t') && (*p != '\0');p++) ;
		*p++='\0';
		while ((*p == ' ') || (*p == '\t')) p++;
		for (i=0;verbs[i].verb;i++) {
			if (strcasecmp(verbs[i].verb,buf) == 0) break;
		}
		switch (verbs[i].vtype) {
		case boolean:
			DPRINT(("clamav_config bool \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			if ((strcasecmp(p,"yes") == 0) ||
			    (strcasecmp(p,"on") == 0)) {
				*((int*)((char*)cfg+verbs[i].where))=1;
			} else if ((strcasecmp(p,"no") == 0) ||
				   (strcasecmp(p,"off") == 0)) {
				*((int*)((char*)cfg+verbs[i].where))=0;
			} else {
				ERRLOG((LOG_ERR,"%s(%d): bad boolean \"%s\"",
					fn,count,p));
			}
			break;
		case integer:
			DPRINT(("clamav_config int \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			q=p+strlen(p)-1;
			switch (*q) {
			case 'k':
			case 'K':
				factor=1024;
				*q='\0';
				break;
			case 'm':
			case 'M':
				factor=1024*1024;
				*q='\0';
				break;
			default:
				factor=1;
				break;
			}
			*((int*)((char*)cfg+verbs[i].where))=atoi(p)*factor;
			break;
		case string:
			*((char**)((char*)cfg+verbs[i].where))=
						(char*)malloc(strlen(p)+1);
			strcpy(*((char**)((char*)cfg+verbs[i].where)),p);
			break;
		case options:
			options_set=1;
			*((unsigned int*)((char*)cfg+verbs[i].where))=
					verb_options(p,fn,count);
			break;
		case badverb:
			ERRLOG((LOG_ERR,"%s(%d): bad verb \"%s\"",
					fn,count,buf));
			break;
		}
	}
	fclose(fp);
#ifndef HAVE_CL_SCANBUFF
	if (!cfg->filescan) {
		ERRLOG((LOG_ERR,"clamav: this version of clamav does not "
				"support scanning memory buffers, "
				"'filescan' option force set to 'on'"));
		cfg->filescan=1;
	}
#endif
	if (options_set && !cfg->filescan) {
		ERRLOG((LOG_ERR,"clamav: filescan is false, "
				"options will be ignored"));
	}
	DPRINT(("clamav cfg dbdir=%s\n",cfg->dbdir));
	DPRINT(("clamav cfg filescan=%d\n",cfg->filescan));
	DPRINT(("clamav cfg options=0x%08x\n",cfg->clamopts));
	return cfg;
}
