#ifndef LINT
static char *rcsid="$Id: pcre.c,v 1.10 2004/01/29 17:29:24 crosser Exp $";
#endif

/*
	$Log: pcre.c,v $
	Revision 1.10  2004/01/29 17:29:24  crosser
	info messages in the log, bump version
	
	Revision 1.9  2004/01/29 17:12:27  crosser
	complain about too long pattern lines
	
	Revision 1.8  2003/09/18 21:34:56  crosser
	bugfix: clean config line to the beg
	bugfix: ||'s properly in brackets
	
	Revision 1.7  2003/09/15 13:44:20  crosser
	report by setting var
	
	Revision 1.6  2003/09/14 22:14:27  crosser
	switch to varpool API
	
	Revision 1.5  2003/09/10 21:42:52  crosser
	cosmetic
	
	Revision 1.4  2003/09/10 18:07:46  crosser
	remove extra debug pront
	
	Revision 1.3  2003/09/10 14:45:38  crosser
	make it work
	
	Revision 1.2  2003/09/10 14:25:31  crosser
	compiles...
	
	Revision 1.1.1.1  2003/09/10 12:06:27  crosser
	Imported sources
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef HAVE_PCRE_H
# include <pcre.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

#define CONFFILE "pcre.conf"

#define min(x,y) ((x<y)?x:y)

struct _cfg {
	struct _cfg *next;
	char *comm;
	pcre *pcreg;
	pcre_extra *pcreg_e;
};

static int
pcre_setup(void **priv)
{
	struct _cfg **cfgp=(struct _cfg **)priv;
	int rc,count=0,recount=0;
	char buf[512];
	char fbuf[128];
	FILE *fp;
	int options;
	char *eob,*p,*q,*re,*comm;
	char sep;
	pcre *pcreg;
	pcre_extra *pcreg_e;
	const char *err;
	int erroffset;

	DPRINT(("pcre_setup called\n"));

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),CONFFILE);
	if ((fp=fopen(fbuf,"r")) == NULL) {
		ERRLOG((LOG_ERR,"pcre: cannot open config \"%s\": %m",fbuf));
		return 1;
	}
	while (fgets(buf,sizeof(buf),fp)) {
		count++;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		if ((*p != '\r') && (*p != '\n')) {
			ERRLOG((LOG_ERR,
				"pcre: %s(%d): line too long (max is %d)",
						fbuf,count,sizeof(buf)-1));
			return 1;
		}
		while ((p >= buf) && ((*p == '\r') || (*p == '\n'))) *p--='\0';
		if (buf[0] == '\0') continue;
		if (buf[0] == '#') continue;
		eob=p+1;

		options=0;
		sep=buf[0];
		re=buf+1;
		p=re;
		while ((p < eob) && (*p != sep)) p++;
		*p++='\0';
		while ((p < eob) && (*p != ' ') && (*p != '\t')) {
			DPRINT(("flag: %c\n",*p));
			switch (*p) {
			case 'i':
				options |= PCRE_CASELESS;
				break;
			case 's':
				options |= PCRE_DOTALL;
				break;
			case 'm':
				options |= PCRE_MULTILINE;
				break;
			}
			p++;
		}
		while ((p < eob) && ((*p == ' ') || (*p == '\t'))) p++;

		if (*p) {
			comm=(char *)malloc(strlen(p)+1);
			strcpy(comm,p);
		} else {
			comm=(char *)malloc(strlen("Bad pattern match")+1);
			strcpy(comm,"Bad pattern match");
		}

		DPRINT(("re: \"%s\", op=%04x com: \"%s\"\n",re,options,comm));

		pcreg=pcre_compile(re,options,&err,&erroffset,NULL);
		if (pcreg == NULL) {
			ERRLOG((LOG_ERR,
				"pcre: %s(%d): Error compiling regex \"%s\"",
							fbuf,count,re));
			ERRLOG((LOG_ERR,"pcre: at %d: %s\n",erroffset,err));
			return 1;
		}
		pcreg_e=pcre_study(pcreg,0,&err);
		if (err != NULL) {
			ERRLOG((LOG_ERR,
				"pcre: %d(%d): Error studying regex \"%s\"",
							fbuf,count,re));
			ERRLOG((LOG_ERR,"pcre: %s",err));
			return 1;
		}

		recount++;
		(*cfgp)=(struct _cfg *)malloc(sizeof(struct _cfg));
		(*cfgp)->next=NULL;
		(*cfgp)->comm=comm;
		(*cfgp)->pcreg=pcreg;
		(*cfgp)->pcreg_e=pcreg_e;

		cfgp=&((*cfgp)->next);
	}
	if (recount == 0) {
		ERRLOG((LOG_ERR,"pcre: no patterns in the config file"));
	}
	ERRLOG((LOG_INFO,"pcre: %d patterns from %s",recount,fbuf));
	ERRLOG((LOG_INFO,"pcre: %s (%s) OK",VERSION,rcsid));
	return 0;
}

static void
pcre_term(void **priv)
{
	struct _cfg *cfgp=*(struct _cfg **)priv;
	struct _cfg *cur;

	DPRINT(("pcre_term called\n"));
	for (cur=cfgp;cur;cur=cfgp) {
		cfgp=cur->next;
		DPRINT(("freeing %s\n",cur->comm));
		free(cur->comm);
		(pcre_free)(cur->pcreg_e);
		(pcre_free)(cur->pcreg);
		free(cur);
	}
	*priv=NULL;
}

static int
pcre_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	struct _cfg *cfgp;
	int rc;
	char ans[256];

	DPRINT(("pcre_scan called on \"%.*s\" (%d)\n",
		min(40,slab_size(data)),data.beg,slab_size(data)));

	for (cfgp=(struct _cfg *)priv;cfgp;cfgp=cfgp->next) {
		DPRINT(("check against:  %s\n",cfgp->comm));
		rc=pcre_exec(cfgp->pcreg,cfgp->pcreg_e,
				data.beg,slab_size(data),
				0,0,NULL,0);
		switch (rc) {
		case 0:
			snprintf(ans,sizeof(ans),"-1 550 %s",cfgp->comm);
			vp_set_str(vp,VP_ANSWER_STR,ans);
			return ZMSCAN_STOP;
		case PCRE_ERROR_NOMATCH:
			DPRINT(("No match with label \"%s\"\n",cfgp->comm));
			break;
		default:
			ERRLOG((LOG_ERR,"pcre: Error %d regex labelled %s",
						rc,cfgp->comm));
			break;
		}
	}
	return ZMSCAN_CONTINUE;
}
                                                                                
ZMS_MODULE("content_text_plain","pcre",pcre_setup,pcre_term,pcre_scan);
